package magicktest;

import java.io.*;
import magick.ImageInfo;
import magick.MagickImage;
import magick.ProfileInfo;



public class Testtools
{



  /**
   * Compares two image files
   * @param img1 First image file name
   * @param img2 Second image file name
   * @return double difference The pixel difference (MSE metric)
   * @throws IOException
   */
  private static double compareImage(String img1, String img2) throws IOException
  {

    /*
       compare -metric MSE rose.jpg reconstruct.jpg difference.png 29.5615 dB

       MetricOptions[] =
       {
         { "Undefined", (long) UndefinedMetric },
         { "MAE", (long) MeanAbsoluteErrorMetric },
         { "MSE", (long) MeanSquaredErrorMetric },
         { "PAE", (long) PeakAbsoluteErrorMetric },
         { "PSNR", (long) PeakSignalToNoiseRatioMetric },
         { "RMSE", (long) RootMeanSquaredErrorMetric },
         { (char *) NULL, (long) UndefinedMetric }
       }
    */

   if (!new File(img1).exists()) throw new java.io.FileNotFoundException("Fil 1 not found: "+img1);
   if (!new File(img2).exists()) throw new java.io.FileNotFoundException("Fil 2 not found: "+img2);

    String cmd = "compare -metric MSE "+img1+" "+img2+" temp/sletcompareImage.jpg";
    if (!System.getProperty("os.name").equals("Linux")) cmd = "E:\\user\\caramba\\magick-6.2.6-Q8\\"+cmd;

    Process compProces = Runtime.getRuntime().exec(cmd);
    StringBuffer outsb = new StringBuffer(20);

    InputStream std = compProces.getInputStream();
    InputStream err = compProces.getInputStream();

    do {
      int ch =std.read();
      if (ch==-1) break;
      outsb.append( (char) ch);
    } while (true);

    do {
      int ch =err.read();
      if (ch==-1) break;
      System.err.print( (char) ch);
    } while (true);

    System.out.println(cmd + " gave: "+outsb);

    // parse the first number in output
    double difference = Double.parseDouble( outsb.substring(0,outsb.indexOf(" ")) );
    //System.out.println(cmd + " gave: "+difference);
    return difference;
  }





  public static String path_input = "magicktest"+File.separator+"input"+File.separator;
  static String path_actual_output = "magicktest"+File.separator+"actual_output"+File.separator;
  static String path_correct_output = "magicktest"+File.separator+"correct_output"+File.separator;

  /**
   * This flag makes all file comparisons pass and avoids that files are deleted in magictest/actual_output/
   * Set to true and run tests to generate examples of "correct" output.
   * Copy then all files from magictest/actual_output/ to magictest/correct_output/ to define
   * the 'golden' result files which the test should conform to.
   */
  static boolean generate_golden_output = false;


  public static void writeAndCompare(MagickImage image, ImageInfo info, String fileName) throws Exception
  {
    // Delete old files to make sure they dont interfere
    new File(path_actual_output+fileName).delete();
    double maxDiff = 20;

    image.setFileName(path_actual_output+fileName);
    image.writeImage(info);

    if (!generate_golden_output) {

      double dif = compareImage(path_actual_output+fileName, path_correct_output+fileName);

      if (dif> maxDiff) {
        throw new RuntimeException("Image "+fileName+" had a difference of "+dif+ " which is bigger than max allowed of "+maxDiff);
      }
    }
  }



  public void allocateAndFreeSomeMem(int n) {
    byte[] b = new byte[n];
    for (int i=0; i<n; i++) b[i] = (byte) i;
    System.out.print("alloker "+n+" "+ (b[0] + b[(n-1)/2]));
  }




  /**
   * Display the information about the profile supplied.
   *
   * @param profile the profile for which to display
   */
  public static void displayProfile(ProfileInfo profile) {
      if (profile.getName() == null) {
          System.out.println("Profile name is null");
      }
      else {
          System.out.println("Profile name is " + profile.getName());
      }
      if (profile.getInfo() == null) {
          System.out.println("No profile info");
      }
      else {
          System.out.println("Profile length is " + profile.getInfo().length);
      }
  }



  public static void main(String[] args) throws Exception {
     compareImage("cykelTest_Standard.jpg",  "cykelTest_Standard_lys.jpg");
     compareImage("cykelTest_Standard.jpg",  "cykelTest_Standard_lys2.jpg");
     compareImage("cykelTest_Standard.jpg",  "cykelTest_Standard_lys3.jpg");

  }
}
