package magicktest;

import junit.framework.*;
import magick.*;

public class ProfileTestCases extends TestCase {
  protected void setUp() throws Exception {
    super.setUp();
  }

  protected void tearDown() throws Exception {
    super.tearDown();
  }


  /**
   * This crashes on Jmagick-6.2.8
   * See http://www.yeo.id.au/mailman/private/jmagick/2007-June/002606.html
   */
  public void testIptcJM628Crash() throws Exception
  {
    for (int i=0; i<50; i++)
    {
      ImageInfo info = new ImageInfo(Testtools.path_input+ "img_iptc8006_exif2829_icc560.jpg");
      MagickImage image = new MagickImage(info);
      ProfileInfo profile = image.getIptcProfile();
      image.setIptcProfile(profile);
      System.gc();
      Testtools.displayProfile(profile);
      // identify -verbose gives: Profile-8bim: 8006 bytes
      assertEquals(8006, profile.getInfo().length);
    }
  }

  /**
   * This crashes on Jmagick-6.2.8
   * See http://www.yeo.id.au/mailman/private/jmagick/2007-June/002606.html
   */
  public void testIccJM628Crash() throws Exception {
    for (int i=0; i<50; i++)
    {
      ImageInfo info = new ImageInfo(Testtools.path_input+ "img_iptc8006_exif2829_icc560.jpg");
      MagickImage image = new MagickImage(info);
      ProfileInfo profile = image.getColorProfile();
      image.setColorProfile(profile);
      System.gc();
      Testtools.displayProfile(profile);
      // identify -verbose gives:   Profile-icc: 560 bytes
      assertEquals(560, profile.getInfo().length);
    }
  }


  /**
   */
  public void testReadBigIccJpg() throws Exception {
    ImageInfo info = new ImageInfo(Testtools.path_input+ "big_icc_1827908_bytes.jpg");
    MagickImage image = new MagickImage(info);
    ProfileInfo profile = image.getColorProfile();
    Testtools.displayProfile(profile);
    // identify -verbose should give:   Profile-icc: 1827908 bytes
    assertEquals(1827908, profile.getInfo().length);

  }


  /**
   */
  public void testReadBigIptcJpg() throws Exception {
      ImageInfo info = new ImageInfo(Testtools.path_input+ "big_iptc_1477798_bytes_clippath.jpg");
      MagickImage image = new MagickImage(info);
      ProfileInfo profile = image.getIptcProfile();
      Testtools.displayProfile(profile);
      // identify -verbose should give:   Profile-iptc: 1477798 bytes
      assertEquals(1827908, profile.getInfo().length);

  }





}
