package magicktest;

import java.io.*;

import java.awt.*;

import junit.framework.*;
import magick.*;
import test.*;

/**
 * Standard tests from Eric Yeos original Test.java converted to test cases.
 * All these test should pass certify a JMagick of acceptable quality
 * Not finished yet
 * @author Jacob Nordfalk
 */

public class MainTestCase extends TestCase {


  protected void setUp() throws Exception {
    super.setUp();
    if (Testtools.generate_golden_output) {
      System.err.println("************************************* WARNING ***********************************************");
      System.err.println("* With generate_golden_output = true you are generating 'golden' output, instead of testing *");
      System.err.println("*********************************************************************************************");
    }
  }

  protected void tearDown() throws Exception {
    super.tearDown();
  }








  /**
   * Test of diverse operations on a small is processed  correctly
   * Values on Linux with IM 6.2.8:
    <pre>
    Scaled to 60x30
    Depth 8
    Quality is 75
    Colorspace is 1
    Resolution units is 1
    X resolution is 72.0
    Y resolution is 72.0
    Size blob is 4538
    Colors 0
    Total colors 0
    Depth is 8
    Old colour PixelPacket(255,255,255,0)
    New colour PixelPacket(255,0,0,0)
    </pre>
   */
  public void testMain1() throws Exception
  {
    Rectangle rect = new Rectangle(0, 0, 80, 40);
    int flags = Magick.parseImageGeometry("60x50", rect);
    assertEquals("Scaled to ",60,rect.width);
    assertEquals("Scaled to ",30,rect.height);

    // Copy an image.
    ImageInfo info = new ImageInfo(Testtools.path_input+ "pics.jpg");
    info.setPage("50x50+0+0");
    info.setUnits(ResolutionType.PixelsPerInchResolution);
    info.setColorspace(ColorspaceType.RGBColorspace);
    info.setBorderColor(PixelPacket.queryColorDatabase("red"));
    info.setDepth(8);
    assertEquals("Depth ", 8, info.getDepth());
    info.setDepth(0);
    MagickImage image = new MagickImage(info);
    image.setImageAttribute("Comment", "Processed by JMagick");
    assertEquals("Quality is ", 75, image.getQuality());
    assertEquals("Colorspace is ", 1, image.getColorspace());
    assertEquals("Resolution units is ", 1, image.getUnits());
    assertEquals("X resolution is ", 72, image.getXResolution(),0.1);
    assertEquals("Y resolution is ", 72, image.getYResolution(),0.1);
    assertEquals("Size blob is ", 4538, image.sizeBlob());
    assertEquals("Colors ", 0, image.getColors());
    assertEquals("Total colors ", 0, image.getTotalColors());
    assertEquals("Depth is ", 8, image.getDepth());
    image.signatureImage();
    Testtools.writeAndCompare(image, info, "copy.jpg");

    // Background Color
    assertEquals("Old colour ", image.getBackgroundColor().toString(), new PixelPacket(255,255,255,0).toString());
    image.setBackgroundColor(PixelPacket.queryColorDatabase("red"));
    assertEquals("New colour ", image.getBackgroundColor().toString(), new PixelPacket(255,0,0,0).toString());

    // Profile test
    assertEquals("Number of generic profiles ", 0, image.getGenericProfileCount());
    image.setColorProfile(new ProfileInfo("Test", new byte[20]));
    assertEquals( "Test", image.getColorProfile().getName());
    assertEquals( 20, image.getColorProfile().getInfo().length);

    // Border image
    image.setBorderColor(PixelPacket.queryColorDatabase("green"));
    MagickImage borderedImage = image.borderImage(new Rectangle(0, 0, 10, 20));
    Testtools.writeAndCompare(borderedImage, info, "border.jpg");
  }


  /**
   * Test of diverse operations on a small is processed  correctly
   */
  public void testMain3() throws Exception
  {
    ImageInfo info = new ImageInfo();
    MagickImage image = new MagickImage(new ImageInfo("magicktest/input/pics.jpg"));

    // Raise image
    MagickImage raisedImage = new MagickImage(new ImageInfo("magicktest/input/pics.jpg"));
    raisedImage.raiseImage(new Rectangle(0, 0, 10, 20), true);
    raisedImage.setFileName("raised.jpg");
    raisedImage.writeImage(info);


      // Montage test
      MagickImage images[] = new MagickImage[2];
      images[0] = image;
      images[1] = image;
      MagickImage seqImage = new MagickImage(images);
      MontageInfo montageInfo = new MontageInfo(new ImageInfo());
      montageInfo.setFileName("montage.jpg");
      montageInfo.setTitle("Melbourne");
      montageInfo.setBorderWidth(5);
      MagickImage montage = seqImage.montageImages(montageInfo);
      montage.writeImage(new ImageInfo());

      // Converting the montage into a blob
      montage.setMagick("JPG");
      byte[] mblob = montage.imageToBlob(new ImageInfo());
      System.out.println("Length "+mblob.length);

      // Test average
      MagickImage average = seqImage.averageImages();
      average.setFileName("average.jpg");
      average.writeImage(new ImageInfo());

      // Image to blob
      info = new ImageInfo();
      byte[] blob = image.imageToBlob(info);

      // Blob to image
      info = new ImageInfo();
      MagickImage blobImage = new MagickImage(info, blob);
      Dimension imageDim = blobImage.getDimension();
      System.out.println("Blob width is " + imageDim.width);
      System.out.println("Blob heght is " + imageDim.height);
      System.out.println(imageDim);
      blobImage.setFileName("blob.jpg");
      blobImage.writeImage(info);

      // JPEG Image to GIF blob
      image.setMagick("GIF");
      blob = image.imageToBlob(info);
      try {
          FileOutputStream out = new FileOutputStream("blob.gif");
          out.write(blob);
          out.close();
      }
      catch (IOException ex) {
          System.out.println("Unable to write blob to file: " + ex);
      }
  }



  /**
   * Test of diverse operations on a small is processed  correctly
   */
  public void testMain2() throws Exception
  {
    ImageInfo info = new ImageInfo();
    MagickImage image;
    Dimension imageDim;
          // Rotation and shear
          image = new MagickImage(new ImageInfo("magicktest/input/pics.jpg"));
          MagickImage rotated = image.rotateImage(45.0);
          rotated.setFileName("rotated.jpg");
          rotated.writeImage(info);
          MagickImage sheared = image.shearImage(50.0, 10.0);
          sheared.setFileName("sheared.jpg");
          sheared.writeImage(info);
          MagickImage scaled = image.scaleImage(100, 80);
          scaled.setFileName("scaled.jpg");
          scaled.writeImage(info);

          // Cloning
          imageDim = image.getDimension();
          System.out.println("Width is " + imageDim.width);
          System.out.println("Height is " + imageDim.height);
          System.out.println("Depth is " + image.getDepth());
          System.out.println("Storage class is " + image.getStorageClass());
          System.out.println("Comment is \""
                  + image.getImageAttribute("Comment") + "\"");
          MagickImage clonedImage = image.cloneImage(0, 0, false);
          clonedImage.setFileName("clone.jpg");
          clonedImage.writeImage(info);
  }
          /**
           * Test of diverse operations on a small is processed  correctly
           */
          public void testMain4() throws Exception
          {
            ImageInfo info = new ImageInfo();
            MagickImage image = new MagickImage(new ImageInfo("magicktest/input/pics.jpg"));

            Rectangle rect;


          // Quantization
          MagickImage quantizedImage = new MagickImage(new ImageInfo(
                  "magicktest/input/pics.jpg"));
          QuantizeInfo quantizeInfo = new QuantizeInfo();
          quantizeInfo.setColorspace(ColorspaceType.GRAYColorspace);
          quantizeInfo.setNumberColors(256);
          quantizeInfo.setTreeDepth(4);
          System.out.println("QuantizeImage "
                  + quantizedImage.quantizeImage(quantizeInfo));
          System.out.println("Colors " + quantizedImage.getColors());
          System.out.println("Total colors "
                  + quantizedImage.getTotalColors());
          quantizedImage.setFileName("quantized.png");
          quantizedImage.writeImage(info);
//            for (int i = 0; i < quantizedImage.getColors(); i++) {
//                PixelPacket pp = quantizedImage.getColormap(i);
//                System.out.println("Colormap[" + i + "] = (" + pp.getRed()
//                        + ", " + pp.getGreen() + ", " + pp.getBlue() + ")");
//            }
//            PixelPacket[] ppArray = quantizedImage.getColormap();
//            for (int i = 0; i < quantizedImage.getColors(); i++) {
//                System.out.println("Colormap2[" + i + "] = ("
//                        + ppArray[i].getRed() + ", " + ppArray[i].getGreen()
//                        + ", " + ppArray[i].getBlue() + ")");
//            }

          // Create an image from scratch
          MagickImage blankImage = new MagickImage();
          byte[] pixels = new byte[200 * 100 * 4];
          for (int i = 0; i < 200 * 100; i++) {
              pixels[4 * i] = (byte) 255;
              pixels[4 * i + 1] = (byte) 255;
              pixels[4 * i + 2] = (byte) 255;
              pixels[4 * i + 3] = (byte) 0;
          }
          blankImage.constituteImage(200, 100, "RGBA", pixels);

          // Put a red rectangle around the border
          DrawInfo drawInfo = new DrawInfo(new ImageInfo());
          drawInfo.setPrimitive("Rectangle 10 10 190 90");
          drawInfo.setStroke(PixelPacket.queryColorDatabase("red"));
          drawInfo.setFill(PixelPacket.queryColorDatabase("white"));
          blankImage.drawImage(drawInfo);

          // Annotate the image with a green Hello
          ImageInfo blankImageInfo = new ImageInfo();
          DrawInfo annotateInfo = new DrawInfo(blankImageInfo);
          annotateInfo.setOpacity(0);
          annotateInfo.setFont("fixed");
          annotateInfo.setFill(PixelPacket.queryColorDatabase("green"));
          annotateInfo.setText("Hello");
          annotateInfo.setGeometry("+30+30");
          blankImage.annotateImage(annotateInfo);

          blankImage.setFileName("blank.jpg");
          blankImage.writeImage(info);

          // Make the white page of the image transparent
          blankImage.transparentImage(
                  PixelPacket.queryColorDatabase("white"), 65535);
          blankImage.setFileName("transparent.png");
          blankImage.writeImage(info);

          // Crop image
          rect = new Rectangle(20, 20, 150, 120);
          MagickImage cropped = image.cropImage(rect);
          cropped.setFileName("cropped.jpg");
          cropped.writeImage(info);

          // Chop image
          rect = new Rectangle(0, 0, 150, 120);
          MagickImage chopped = image.chopImage(rect);
          chopped.setFileName("chopped.jpg");
          chopped.writeImage(info);

          // Sharpen image
          MagickImage sharpened = image.sharpenImage(1.0, 5.0);
          sharpened.setFileName("sharpened.jpg");
          sharpened.writeImage(info);

          // Despeckle image
          MagickImage despeckled = image.despeckleImage();
          despeckled.setFileName("despeckled.jpg");
          despeckled.writeImage(info);

          // Convolve image
          double[] kernel = new double[9];
          for (int i = 0; i < 9; i++) {
              kernel[i] = 1.0;
          }
          kernel[4] = 2.0;
          MagickImage convolvedImage = image.convolveImage(3, kernel);
          convolvedImage.setFileName("convolved.jpg");
          convolvedImage.writeImage(info);

          // Finally display the image.
          MagickWindow window = new MagickWindow(image);
          window.setVisible(true);

          // MagickInfo test
          MagickInfo minfo = new MagickInfo("JPEG");
          System.out.println("JPG description: " + minfo.getDescription());
  }



}
